% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_combinations}
\alias{torch_combinations}
\title{Combinations}
\arguments{
\item{input}{(Tensor) 1D vector.}

\item{r}{(int, optional) number of elements to combine}

\item{with_replacement}{(boolean, optional) whether to allow duplication in combination}
}
\description{
Combinations
}
\section{combinations(input, r=2, with_replacement=False) -> seq }{


Compute combinations of length \eqn{r} of the given tensor. The behavior is similar to
python's \code{itertools.combinations} when \code{with_replacement} is set to \code{False}, and
\code{itertools.combinations_with_replacement} when \code{with_replacement} is set to \code{True}.
}

\examples{
if (torch_is_installed()) {

a = c(1, 2, 3)
tensor_a = torch_tensor(a)
torch_combinations(tensor_a)
torch_combinations(tensor_a, r=3)
torch_combinations(tensor_a, with_replacement=TRUE)
}
}
