% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_addcdiv}
\alias{torch_addcdiv}
\title{Addcdiv}
\arguments{
\item{input}{(Tensor) the tensor to be added}

\item{tensor1}{(Tensor) the numerator tensor}

\item{tensor2}{(Tensor) the denominator tensor}

\item{value}{(Number, optional) multiplier for \eqn{\mbox{tensor1} / \mbox{tensor2}}}

\item{out}{(Tensor, optional) the output tensor.}
}
\description{
Addcdiv
}
\section{addcdiv(input, tensor1, tensor2, *, value=1, out=None) -> Tensor }{


Performs the element-wise division of \code{tensor1} by \code{tensor2},
multiply the result by the scalar \code{value} and add it to \code{input}.
}

\section{Warning}{

Integer division with addcdiv is deprecated, and in a future release
addcdiv will perform a true division of \code{tensor1} and \code{tensor2}.
The current addcdiv behavior can be replicated using \code{\link[=torch_floor_divide]{torch_floor_divide()}}
for integral inputs
(\code{input} + \code{value} * \code{tensor1} // \code{tensor2})
and \code{\link[=torch_div]{torch_div()}} for float inputs
(\code{input} + \code{value} * \code{tensor1} / \code{tensor2}).
The new addcdiv behavior can be implemented with \code{\link[=torch_true_divide]{torch_true_divide()}}
(\code{input} + \code{value} * torch.true_divide(\code{tensor1},
\code{tensor2}).

\deqn{
    \mbox{out}_i = \mbox{input}_i + \mbox{value} \times \frac{\mbox{tensor1}_i}{\mbox{tensor2}_i}
}

The shapes of \code{input}, \code{tensor1}, and \code{tensor2} must be
broadcastable .

For inputs of type \code{FloatTensor} or \code{DoubleTensor}, \code{value} must be
a real number, otherwise an integer.
}

\examples{
if (torch_is_installed()) {

t = torch_randn(c(1, 3))
t1 = torch_randn(c(3, 1))
t2 = torch_randn(c(1, 3))
torch_addcdiv(t, t1, t2, 0.1)
}
}
