% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_randint}
\alias{torch_randint}
\title{Randint}
\arguments{
\item{low}{(int, optional) Lowest integer to be drawn from the distribution. Default: 0.}

\item{high}{(int) One above the highest integer to be drawn from the distribution.}

\item{size}{(tuple) a tuple defining the shape of the output tensor.}

\item{generator}{(\code{torch.Generator}, optional) a pseudorandom number generator for sampling}

\item{out}{(Tensor, optional) the output tensor.}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned tensor.        Default: if \code{None}, uses a global default (see \code{torch_set_default_tensor_type}).}

\item{layout}{(\code{torch.layout}, optional) the desired layout of returned Tensor.        Default: \code{torch_strided}.}

\item{device}{(\code{torch.device}, optional) the desired device of returned tensor.        Default: if \code{None}, uses the current device for the default tensor type        (see \code{torch_set_default_tensor_type}). \code{device} will be the CPU        for CPU tensor types and the current CUDA device for CUDA tensor types.}

\item{requires_grad}{(bool, optional) If autograd should record operations on the        returned tensor. Default: \code{False}.}
}
\description{
Randint
}
\section{randint(low=0, high, size, *, generator=None, out=None, \ }{


dtype=None, layout=torch.strided, device=None, requires_grad=False) -> Tensor

Returns a tensor filled with random integers generated uniformly
between \code{low} (inclusive) and \code{high} (exclusive).

The shape of the tensor is defined by the variable argument \code{size}.

.. note:
With the global dtype default (\code{torch_float32}), this function returns
a tensor with dtype \code{torch_int64}.
}

\examples{
if (torch_is_installed()) {

torch_randint(3, 5, list(3))
torch_randint(0, 10, size = list(2, 2))
torch_randint(3, 10, list(2, 2))
}
}
