% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_matrix_power}
\alias{torch_matrix_power}
\title{Matrix_power}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{n}{(int) the power to raise the matrix to}
}
\description{
Matrix_power
}
\section{matrix_power(input, n) -> Tensor }{


Returns the matrix raised to the power \code{n} for square matrices.
For batch of matrices, each individual matrix is raised to the power \code{n}.

If \code{n} is negative, then the inverse of the matrix (if invertible) is
raised to the power \code{n}.  For a batch of matrices, the batched inverse
(if invertible) is raised to the power \code{n}. If \code{n} is 0, then an identity matrix
is returned.
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(2, 2, 2))
a
torch_matrix_power(a, 3)
}
}
