% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_cumprod}
\alias{torch_cumprod}
\title{Cumprod}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{dim}{(int) the dimension to do the operation over}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned tensor.        If specified, the input tensor is casted to \code{dtype} before the operation        is performed. This is useful for preventing data type overflows. Default: None.}

\item{out}{(Tensor, optional) the output tensor.}
}
\description{
Cumprod
}
\section{cumprod(input, dim, out=None, dtype=None) -> Tensor }{


Returns the cumulative product of elements of \code{input} in the dimension
\code{dim}.

For example, if \code{input} is a vector of size N, the result will also be
a vector of size N, with elements.

\deqn{
    y_i = x_1 \times x_2\times x_3\times \dots \times x_i
}
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(10))
a
torch_cumprod(a, dim=1)
}
}
