% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-init.R
\name{nn_init_orthogonal_}
\alias{nn_init_orthogonal_}
\title{Orthogonal initialization}
\usage{
nn_init_orthogonal_(tensor, gain = 1)
}
\arguments{
\item{tensor}{an n-dimensional \code{Tensor}}

\item{gain}{optional scaling factor}
}
\description{
Fills the input \code{Tensor} with a (semi) orthogonal matrix, as
described in \verb{Exact solutions to the nonlinear dynamics of learning in deep linear neural networks} - Saxe, A. et al. (2013). The input tensor must have
at least 2 dimensions, and for tensors with more than 2 dimensions the
trailing dimensions are flattened.
}
\examples{
if (torch_is_installed()) {
w <- torch_empty(3,5)
nn_init_orthogonal_(w)

}
}
