% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_noise_bias}
\alias{add_noise_bias}
\title{Add Noise and Bias to Matrix Data}
\usage{
add_noise_bias(matrix_data)
}
\arguments{
\item{matrix_data}{Numeric matrix to add noise to}
}
\value{
A \code{list} containing three noisy \code{matrix} objects:
\item{n1}{Matrix with the first realization of random Gaussian noise.}
\item{n2}{Matrix with a second, different realization of random Gaussian noise.}
\item{nb}{Matrix with both random noise and a systematic negative bias.}
}
\description{
Creates noisy versions of a distance matrix by adding random noise and/or systematic bias.
Useful for testing robustness of algorithms to measurement errors and systematic biases.
}
\details{
The function generates three variants of the input matrix:
\enumerate{
\item n1: Matrix with random Gaussian noise
\item n2: Different realization of random noise
\item nb: Matrix with both random noise and systematic negative bias
}

The noise level is scaled relative to the data mean to maintain realistic error magnitudes.
}
\examples{
# Create sample distance matrix
dist_mat <- matrix(runif(100), 10, 10)
dist_mat[lower.tri(dist_mat)] <- t(dist_mat)[lower.tri(dist_mat)]
diag(dist_mat) <- 0

# Generate noisy versions
noisy_variants <- add_noise_bias(dist_mat)
}
