\name{outlet}
\alias{outlet}
\title{Conveniently query a subset of a matrix}
\description{
  Convenience function to extract a pixel and its neighbourhood from matrices, e.g. to query raster maps.
}
\usage{
  outlet(map,out,radius = 2)
}
\arguments{
  \item{map}{matrix}
  \item{out}{Center of the matrix to be extracted}
  \item{radius}{Radius of the matrix to be extracted}
}
\details{
The function can be used to find a catchment outlet using a drainage area map generated by \code{atb}, when the coordinates are approximately known (for instance from the location of a discharge station). These coordinates can then be used by \code{subcatch}. However, note that \code{atb} uses a multiple direction flow algorithm, while \code{subcatch} uses single flow. Therefore, the drainage area for a pixel calculated by \code{atb} is likely to differ from the catchment area identified by \code{subcatch}.
}
\value{Square matrix of size (radius * 2 + 1) 
}
\references{See \url{http://paramo.cc.ic.ac.uk/topmodel_tutorial} for examples.}
\author{Wouter Buytaert, Imperial College London}
%\note{}
\seealso{\code{\link{subcatch}}}
%\examples{}
%\keyword{}
