% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-style.R
\name{grid_style_row}
\alias{grid_style_row}
\title{Set grid row style}
\usage{
grid_style_row(
  grid,
  expr,
  background = NULL,
  color = NULL,
  fontWeight = NULL,
  ...,
  class = NULL,
  cssProperties = NULL
)
}
\arguments{
\item{grid}{A grid created with \code{\link[=datagrid]{datagrid()}}.}

\item{expr}{An expression giving position of row. Must return a logical vector.}

\item{background}{Background color.}

\item{color}{Text color.}

\item{fontWeight}{Font weight, you can use \code{"bold"} for example.}

\item{...}{Other CSS properties.}

\item{class}{CSS class to apply to the row.}

\item{cssProperties}{Alternative to specify CSS properties with a named list.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Apply styles to an entire row identified by an expression.
}
\examples{
library(toastui)

datagrid(mtcars) \%>\%
  grid_style_row(
    mpg > 19,
    background = "#F781BE"
  )

datagrid(mtcars) \%>\%
  grid_style_row(
    vs == 0,
    background = "#E41A1C80",
    color = "#FFF"
  ) \%>\%
  grid_style_row(
    vs == 1,
    background = "#377EB880"
  )


# Use rlang to use character
library(rlang)
my_var <- "disp"
datagrid(mtcars) \%>\%
  grid_style_row(
    !!sym(my_var) > 180,
    background = "#F781BE"
  )




}
