% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-editor.R
\name{grid_editor_date}
\alias{grid_editor_date}
\title{Grid editor for date/time columns}
\usage{
grid_editor_date(
  grid,
  column,
  format = "yyyy-MM-dd",
  type = c("date", "month", "year"),
  timepicker = c("none", "tab", "normal"),
  weekStartDay = NULL,
  language = NULL
)
}
\arguments{
\item{grid}{A table created with \code{\link[=datagrid]{datagrid()}}.}

\item{column}{Column for which to activate the date picker.}

\item{format}{Date format, default is \code{"yyyy-MM-dd"}.}

\item{type}{Type of selection: date, month or year.}

\item{timepicker}{Add a timepicker.}

\item{weekStartDay}{Start of the week : 'Sun' (default), 'Mon', ..., 'Sat'}

\item{language}{Either \code{"en"} or \code{"ko"} the builtin language, or \code{"custom"} to use texts defined in \code{datagrid(datepicker_locale = list(...))}, see example.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Allow to edit content of columns with a calendar and time picker,
then retrieve value server-side in shiny application with \code{input$<outputId>_data}.
}
\examples{
library(toastui)

dat <- data.frame(
  date = Sys.Date() + 1:10,
  date_locale = format(Sys.Date() + 1:10, format = "\%d/\%m/\%Y"),
  month = format(Sys.Date() + 1:10, format = "\%Y-\%m"),
  year = format(Sys.Date() + 1:10, format = "\%Y"),
  time1 = Sys.time() + 1:10,
  time2 = Sys.time() + 1:10
)


datagrid(
  data = dat,
  datepicker_locale = list(
    titles = list(
      DD = c(
        "Dimanche", "Lundi", "Mardi",
        "Mercredi", "Jeudi", "Vendredi", "Samedi"
      ),
      D = c("Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam"),
      MMMM = c(
        "Janvier", "F\u00e9vrier", "Mars",
        "Avril", "Mai", "Juin", "Juillet",
        "Ao\u00fbt", "Septembre", "Octobre",
        "Novembre", "D\u00e9cembre"
      ),
      MMM = c(
        "Jan", "F\u00e9v", "Mar", "Avr",
        "Mai", "Juin", "Juil", "Aou",
        "Sept", "Oct", "Nov", "D\u00e9c"
      )
    ),
    titleFormat = "MMM yyyy",
    todayFormat = "DD dd MMMM yyyy",
    date = "Date",
    time = "Heure"
  )
) \%>\%
  grid_editor_date(
    column = "date"
  )\%>\%
  grid_editor_date(
    column = "date_locale",
    format = "dd/MM/yyyy",
    language = "custom",
    weekStartDay = "Mon"
  ) \%>\%
  grid_editor_date(
    column = "month",
    type = "month",
    format = "yyyy-MM"
  ) \%>\%
  grid_editor_date(
    column = "year",
    type = "year",
    format = "yyyy"
  ) \%>\%
  grid_editor_date(
    column = "time1",
    timepicker = "tab",
    format = "yyyy-MM-dd HH:mm"
  ) \%>\%
  grid_editor_date(
    column = "time2",
    timepicker = "normal",
    format = "yyyy-MM-dd HH:mm"
  )
}
\seealso{
\code{\link{grid_editor}} for normal inputs.
}
