% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-header.R
\name{grid-header}
\alias{grid-header}
\alias{grid_header}
\alias{grid_complex_header}
\title{Header options}
\usage{
grid_header(
  grid,
  complexColumns = NULL,
  columns = NULL,
  align = NULL,
  valign = NULL,
  height = NULL
)

grid_complex_header(grid, ..., height = 80)
}
\arguments{
\item{grid}{A table created with \code{\link[=datagrid]{datagrid()}}.}

\item{complexColumns}{\code{list}. This options creates new parent
headers of the multiple columns which includes the headers of
specified columns, and sets up the hierarchy.}

\item{columns}{\code{list}. Options for column's header.}

\item{align}{Horizontal alignment of the header content.
Available values are 'left', 'center', 'right'.}

\item{valign}{Vertical alignment of the row header content.
Available values are 'top', 'middle', 'bottom'.}

\item{height}{Numeric. The height of the header area.}

\item{...}{Named arguments to merge columns under a common header,
e.g. \code{newcol = c("col1", "col2")}.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Properties to modify grid's header, like creating grouped header.
}
\examples{
library(toastui)

datagrid(rolling_stones_50) \%>\%
  grid_header(
    align = "left",
    height = "150px"
  )


# Create columns groups
datagrid(iris) \%>\%
  grid_complex_header(
    "Sepal" = c("Sepal.Length", "Sepal.Width"),
    "Petal" = c("Petal.Length", "Petal.Width")
  )


# or use the full form to use more options
datagrid(iris) \%>\%
  grid_columns(
    columns = c("Petal.Length", "Petal.Width"),
    header = c("Length", "Width")
  ) \%>\%
  grid_header(
    complexColumns = list(
      list(
        header = "Sepal",
        name = "Sepal",
        hideChildHeaders = TRUE,
        resizable = TRUE,
        childNames = c("Sepal.Length", "Sepal.Width")
      ),
      list(
        header = "Petal",
        name = "Petal",
        childNames = c("Petal.Length", "Petal.Width")
      )
    ),
    height = 80,
    valign = "middle"
  )


# Custom HTML in header
# (not that sorting is incompatible with)
library(htmltools)
datagrid(mtcars) \%>\% 
  grid_columns(
    columns = "mpg",
    minWidth = 120,
    header = tags$div(
      tags$b("Miles/(US) gallon"),
      tags$br(),
      tags$i("numeric")
    )
  ) \%>\% 
  grid_header(
    columns = list(
      list(
        name = "mpg",
        align = "left",
        renderer = JS("DatagridColumnHeaderHTML")
      )
    )
  )

}
