% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-proxy.R
\name{calendar-proxy-navigate}
\alias{calendar-proxy-navigate}
\alias{cal_proxy_next}
\alias{cal_proxy_prev}
\alias{cal_proxy_today}
\alias{cal_proxy_date}
\title{Navigate into a calendar with Proxy}
\usage{
cal_proxy_next(proxy)

cal_proxy_prev(proxy)

cal_proxy_today(proxy)

cal_proxy_date(proxy, date)
}
\arguments{
\item{proxy}{A \code{\link[=calendar_proxy]{calendar_proxy()}} \code{htmlwidget} object.}

\item{date}{A specific date to navigate to.}
}
\value{
A \code{calendar_proxy} object.
}
\description{
Those functions allow to navigate in the calendar from the server in a Shiny application.
}
\examples{
library(shiny)
library(toastui)

ui <- fluidPage(
  tags$h2("Navigate in calendar with actionButtons"),
  actionButton(
    inputId = "prev_date",
    label = "Previous",
    icon = icon("chevron-left")
  ),
  actionButton(
    inputId = "next_date",
    label = "Next",
    icon = icon("chevron-right")
  ),
  actionButton(
    inputId = "today",
    label = "Today"
  ),
  fluidRow(
    column(
      width = 9,
      calendarOutput(outputId = "my_calendar")
    ),
    column(
      width = 3,
      verbatimTextOutput("result")
    )
  )
)

server <- function(input, output, session) {

  output$my_calendar <- renderCalendar({
    calendar()
  })

  output$result <- renderPrint({
    input$my_calendar_dates
  })

  observeEvent(input$prev_date, cal_proxy_prev("my_calendar"))
  observeEvent(input$next_date, cal_proxy_next("my_calendar"))
  observeEvent(input$today, cal_proxy_today("my_calendar"))

}


if (interactive())
  shinyApp(ui, server)
}
\seealso{
Other calendar proxy methods: 
\code{\link{cal_proxy_clear}()},
\code{\link{cal_proxy_clear_selection}()},
\code{\link{cal_proxy_options}()},
\code{\link{cal_proxy_toggle}()},
\code{\link{cal_proxy_view}()},
\code{\link{calendar-proxy-schedule}},
\code{\link{calendar_proxy}()}
}
\concept{calendar proxy methods}
