% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_.R
\name{sp_create_folder}
\alias{sp_create_folder}
\title{Create Sharepoint Folder}
\usage{
sp_create_folder(folder_path, site = NULL, drive = NULL)
}
\arguments{
\item{folder_path}{Path to the new folder}

\item{site}{Site identifier. Can be the site name, id, URL, or an ms_site object. If no site identifier is provided, uses the stored default site if it exists.}

\item{drive}{Drive identifier. Can be the drive name, id, or an ms_drive object. If site is provided but drive is not, uses the first drive of the provided site. If neither is provided, uses the stored default drive if it exists.}
}
\value{
returns \code{folder_path} invisibly
}
\description{
Wrapper around the \verb{$create_folder()} method from \link[Microsoft365R:ms_drive]{Microsoft365R::ms_drive}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Set site/drive defaults
sp_defaults("Data Analytics")

# Create a folder
sp_create_folder("new/folder")
\dontshow{\}) # examplesIf}
}
