% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tmlenet-package.R
\docType{data}
\name{df_netKmax2}
\alias{df_netKmax2}
\title{An example of a row-dependent dataset with known network of at most 2 friends.}
\format{A data frame with 1,000 dependent observations (rows) and 6 variables:
\describe{
  \item{IDs}{unique observation identifier}
  \item{Y}{binary outcome that depends on unit's baseline covariate value and exposure in \code{W1}, \code{A}, as well as the
     baseline covariate values and exposures \code{W1}, \code{A} of observations in the friend network \code{Net_str}}
  \item{nFriends}{number of friends for each observation (row), range 0-2}
  \item{W1}{binary baseline covariate (independent)}
  \item{A}{binary exposure status that depends on unit's baseline covariate value in \code{W1}, as well as the
     baseline covariate values \code{W1} of observations in the friend network \code{Net_str}}
  \item{Net_str}{each observation is a string of space separated friend IDs (this can be either observation IDs or
     just space separated friend row numbers)}
}}
\usage{
data(df_netKmax2)
}
\description{
Simulated dataset containing measured i.i.d. baseline covariate (\code{W1}), dependent binary exposure (\code{A})
 and binary binary outcome (\code{Y}), along with a known network of friends encoded by strings on space separated
 friend IDs in \code{Net_str}.
 The 1,000 baseline covariates \code{W1} were sampled as i.i.d.,
 while the exposure value of \code{A} for each observation \code{i} was sampled
 conditionally on the value of \code{i}'s baseline covariate \code{W1[i]},
 as well as the baseline covariate values of \code{i}'s friends in \code{Net_str}.
 Similarly, the binary outcome \code{Y} for each observation was generated conditionally on \code{i}'s
 exposure and baseline covariates values in (\code{W1[i]},\code{A[i]}),
 as well as the values of exposures and baseline covariates of \code{i}'s friends in \code{Net_str}.
 Individual variables are described below.
}
\keyword{datasets}

