% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmap_icons.R
\name{tmap_icons}
\alias{tmap_icons}
\alias{marker_icon}
\title{Specify icons}
\usage{
tmap_icons(file, width = 48, height = 48, keep.asp = TRUE,
  just = c("center", "center"), as.local = TRUE, ...)

marker_icon()
}
\arguments{
\item{file}{character value/vector containing the file path(s) or url(s).}

\item{width}{width of the icon. If \code{keep.asp}, this is interpreted as the maximum width.}

\item{height}{height of the icon. If \code{keep.asp}, this is interpreted as the maximum height.}

\item{keep.asp}{keep the aspect ratio of the png image. If \code{TRUE} and the aspect ratio differs from \code{width/height} either \code{width} or \code{height} is adjusted accordingly.}

\item{just}{justification of the icons relative to the point coordinates.  The first value specifies horizontal and the second value vertical justification. Possible values are: \code{"left"} , \code{"right"}, \code{"center"}, \code{"bottom"}, and \code{"top"}. Numeric values of 0 specify left alignment and 1 right alignment. The default value of \code{just} is \code{c("center", "center")}.}

\item{as.local}{if the \code{file} is a url, should it be saved to local temporary file?}

\item{...}{arguments passed on to \code{\link[leaflet:icons]{icons}}. When \code{iconWidth}, \code{iconHeight}, \code{iconAnchorX} and \code{iconAnchorY} are specified, they override \code{width} and \code{height}, and \code{just}.}
}
\value{
icon data (see \code{\link[leaflet:icons]{icons}})
}
\description{
Specifies icons from a png images, which can be used as markers in thematic maps. The function \code{marker_icon} is the specification of the default marker.
}
\seealso{
\code{\link{tm_symbols}}
}
