% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmap_save.R
\name{tmap_save}
\alias{tmap_save}
\title{Save tmap}
\usage{
tmap_save(tm = NULL, filename = NA, width = NA, height = NA,
  units = NA, dpi = NA, outer.margins = NA, asp = NULL,
  scale = NA, insets_tm = NULL, insets_vp = NULL,
  add.titles = TRUE, verbose = NULL, ...)
}
\arguments{
\item{tm}{tmap object}

\item{filename}{filename including extension, and optionally the path. The extensions pdf, eps, svg, wmf (Windows only), png, jpg, bmp, tiff, and html are supported. If the extension is missing, the file will be saved as a static plot in \code{"plot"} mode and as an interactive map (html) in \code{"view"} mode. The default format for static plots is png, but this can be changed using the option \code{"output.format"} in \code{\link{tmap_options}}.}

\item{height, width}{The width and height of the plot (not applicable for html files). Units are set with the argument \code{units}. If one of them is not specified, this is calculated using the formula asp = width / height, where asp is the estimated aspect ratio of the map. If both are missing, they are set such that width * height is equal to the option \code{"output.size"} in \code{\link{tmap_options}}. This is by default 49, meaning that is the map is a square (so aspect ratio of 1) both width and height are set to 7.}

\item{units}{units for width and height (\code{"in"}, \code{"cm"}, or \code{"mm"}). By default, pixels (\code{"px"}) are used if either width or height is set to a value greater than 50. Else, the units are inches (\code{"in"})}

\item{dpi}{dots per inch. Only applicable for raster graphics. By default it is set to 300, but this can be changed using the option \code{"output.dpi"} in \code{\link{tmap_options}}.}

\item{outer.margins}{overrides the outer.margins argument of \code{\link{tm_layout}} (unless set to \code{NA})}

\item{asp}{if specified, it overrides the asp argument of \code{\link{tm_layout}}. Tip: set to \code{0} if map frame should be placed on the edges of the image.}

\item{scale}{overrides the scale argument of \code{\link{tm_layout}} (unless set to \code{NA})}

\item{insets_tm}{tmap object of an inset map, or a list of tmap objects of multiple inset maps. The number of tmap objects should be equal to the number of viewports specified with \code{insets_vp}.}

\item{insets_vp}{\code{\link[grid:viewport]{viewport}} of an inset map, or a list of \code{\link[grid:viewport]{viewport}}s of multiple inset maps. The number of viewports should be equal to the number of tmap objects specified with \code{insets_tm}.}

\item{add.titles}{add titles to leaflet object}

\item{verbose}{Deprecated. It is now controlled by the tmap option \code{show.messages} (see \code{\link{tmap_options}})}

\item{...}{arguments passed on to device functions or to \code{\link[htmlwidgets:saveWidget]{saveWidget}}}
}
\description{
Save tmap to a file. This can be either a static plot (e.g. png) or an interactive map (html).
}
\examples{
\dontrun{
	data(NLD_muni, NLD_prov)
	m <- tm_shape(NLD_muni) +
		     tm_fill(col="population", convert2density=TRUE, 
                 style="kmeans", 
                 title=expression("Population (per " * km^2 * ")")) +
		     tm_borders("black", alpha=.5) + 
		 tm_shape(NLD_prov) +
		     tm_borders("grey25", lwd=2) +
		tm_style("classic") +
		tm_format("NLD", inner.margins = c(.02, .15, .06, .15)) + 
	    tm_scale_bar(position = c("left", "bottom")) +
	    tm_compass(position=c("right", "bottom"))
	
	tmap_save(m, "choropleth.png", height=7)
	
	data(World)
	m2 <- tm_shape(World) +
		tm_fill("well_being", id="name", title="Well-being") +
		tm_format("World")

	# save image
	tmap_save(m2, "World_map.png", width=1920, height=1080, asp=0)

	# cut left inner margin to make sure Antarctica is snapped to frame
	tmap_save(m2 + tm_layout(inner.margins = c(0, -.1, 0.05, 0.01)), 
        "World_map2.png", width=1920, height=1080, asp=0)
	
	# save interactive plot
	tmap_save(m2, "World_map.html")
}
}
