% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtm.R
\name{qtm}
\alias{qtm}
\title{Quick thematic map plot}
\usage{
qtm(shp, fill = NA, bubble.size = NULL, bubble.col = NULL,
  dot.col = NULL, text = NULL, text.size = 1, text.col = NA,
  line.lwd = NULL, line.col = NULL, raster = NA, borders = NA,
  scale = NA, title = NA, projection = NULL, format = NULL,
  style = NULL, basemaps = NA, ...)
}
\arguments{
\item{shp}{shape object, which is one of
\enumerate{
 \item{\code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygons(DataFrame)}}}
 \item{\code{\link[sp:SpatialPointsDataFrame]{SpatialPoints(DataFrame)}}}
 \item{\code{\link[sp:SpatialLinesDataFrame]{SpatialLines(DataFrame)}}}
 \item{\code{\link[sp:SpatialGridDataFrame]{SpatialGrid(DataFrame)}}}
 \item{\code{\link[sp:SpatialPixelsDataFrame]{SpatialPixels(DataFrame)}}}
 \item{\code{\link[raster:Raster-class]{RasterLayer, RasterStack, or RasterBrick}}}
}
In \code{"view"} mode (see \code{\link{tmap_mode}}) there are two other options. 1) If omitted, an interactive map without thematic layers is opened. 2) In addition, if a character is provided, this character is used as a search query for OpenStreetMap nominatim. This will position the interactive map accordingly. Arguments of \code{\link{tm_view}}, such as \code{set.view} can be passed on directly.}

\item{fill}{either a color to fill the polygons, or name of the data variable in \code{shp} to draw a choropleth. Only applicable when \code{shp} is type 1 (see above).}

\item{bubble.size}{name of the data variable in \code{shp} for the bubble map that specifies the sizes of the bubbles. If neither \code{bubble.size} nor \code{bubble.col} is specified, no bubble map is drawn. Only applicable when \code{shp} is type 1, 2, or 3 (see above).}

\item{bubble.col}{name of the data variable in \code{shp} for the bubble map that specifies the colors of the bubbles. If neither \code{bubble.size} nor \code{bubble.col} is specified, no bubble map is drawn. Only applicable when \code{shp} is type 1, 2, or 3 (see above).}

\item{dot.col}{name of the data variable in \code{shp} for the dot map that specifies the colors of the dots.}

\item{text}{Name of the data variable that contains the text labels. Only applicable when \code{shp} is type 1, 2, or 3 (see above).}

\item{text.size}{Font size of the text labels. Either a constant value, or the name of a numeric data variable. Only applicable when \code{shp} is type 1, 2, or 3 (see above).}

\item{text.col}{name of the data variable in \code{shp} for the that specifies the colors of the text labels. Only applicable when \code{shp} is type 1, 2, or 3 (see above).}

\item{line.lwd}{either a line width or a name of the data variable that specifies the line width. Only applicable when \code{shp} is type 3 (see above).}

\item{line.col}{either a line color or a name of the data variable that specifies the line colors. Only applicable when \code{shp} is type 3 (see above).}

\item{raster}{either a color or a name of the data variable that specifices the raster colors. Only applicable when \code{shp} is type 4, 5, or 6 (see above).}

\item{borders}{color of the polygon borders. Use \code{NA} to omit the borders.}

\item{scale}{numeric value that serves as the global scale parameter. All font sizes, bubble sizes, border widths, and line widths are controled by this value. The parameters \code{bubble.size}, \code{text.size}, and \code{line.lwd} can be scaled seperately with respectively \code{bubble.scale}, \code{text.scale}, and \code{line.scale}.}

\item{title}{main title. For legend titles, use \code{X.style}, where X is layer name (see \code{...}).}

\item{projection}{character that determines the projection. Either a \code{PROJ.4} character string or a shortcut. See \code{\link{get_proj4}} for a list of shortcut values. By default, the projection is used that is defined in the \code{shp} object itself, which can be obtained with \code{\link{get_projection}}.}

\item{format}{\code{\link{tm_layout}} wrapper used for format. Currently available in tmap: "World", "Europe", "NLD", "World_wide", "Europe_wide", "NLD_wide". Own wrappers can be used as well (see details).}

\item{style}{\code{\link{tm_layout}} wrapper used for style. Available in tmap: "bw", "classic". Own wrappers can be used as well (see details).}

\item{basemaps}{basemaps for the view mode. See \code{\link{tm_view}}}

\item{...}{arguments passed on to the \code{tm_*} functions. If an argument name is not unique for a particular \code{tm_} function, then it should be prefixed with the function name without \code{"tm_"}. For instance, \code{style} is an argument of \code{\link{tm_fill}}, \code{\link{tm_bubbles}}, and \code{\link{tm_lines}}. Therefore, in order to define the \code{style} for a choropleth, its arugment name should be \code{fill.style}.}
}
\value{
\code{\link{tmap-element}}
}
\description{
Draw a thematic map quickly.
}
\details{
This function is a convenient wrapper of the main plotting method of stacking \code{\link{tmap-element}}s. The first argument is a shape object (normally specified by \code{\link{tm_shape}}). The next arguments, from \code{fill} to \code{raster}, are the aesthetics from the main layers. The remaining arguments are related to the map layout. Any argument from any main layer can be specified (see \code{...}). It is also possible to stack \code{\link{tmap-element}}s on a \code{qtm} plot. See examples.

For \code{format} any character value, say "xxx" can be used if the wrapper function \code{"tm_format_xxx"} exists. The same applies for the arguments \code{colors}, and \code{style}.
}
\examples{
data(World, rivers, metro)

# just the map
qtm(World)

# choropleth
qtm(World, fill = "economy", format="World", style="col_blind")

qtm(World, fill="HPI", fill.n=9, fill.palette="div", fill.auto.palette.mapping=FALSE, 
	fill.title="Happy Planet Index", format="World", style="gray")

# bubble map
qtm(World, borders = NULL) + qtm(metro, bubble.size = "pop2010", 
    bubble.title.size="Metropolitan Areas", bubble.scale=.5, format = "World")

# TIP: check out these examples in view mode, enabled with tmap_mode("view")
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

