% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx_areas.R
\name{approx_areas}
\alias{approx_areas}
\title{Approximate area sizes of the shapes}
\usage{
approx_areas(shp, unit = "km", unit.size = 1000, total.area = NA)
}
\arguments{
\item{shp}{shape object, i.e., a \code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygons(DataFrame)}}}

\item{unit}{one of
\describe{
    \item{\code{"abs"}:}{Absolute numbers based on polygon coordinates.}
    \item{\code{"prop"}:}{Proportional numbers. In other words, the total of the area sizes equals one.}
    \item{\code{"norm"}:}{Normalized numbers. All area sizes are normalized to the largest area, of which the area size equals one.}
    \item{other:}{For instance, "km", "m", or "miles". For this method, \code{total.area} or \code{unit.size} is required. In this case, the area sizes are returned in squared units, e.g., in squared kilometers.}}
    The default method is \code{"km"}.}

\item{unit.size}{size of the unit in terms of coordinate units. The coordinate system of many projections is approximately in meters while thematic maps typically range many kilometers, so by default \code{unit="km"} and \code{unit.size=1000} (meaning 1 kilometer equals 1000 coordinate units).}

\item{total.area}{total area size of \code{shp} in number of squared units (by default kilometers). Useful if the total area of the \code{shp} differs from a reference total area value.}
}
\value{
Numeric vector of area sizes.
}
\description{
Approximate the area sizes of the polygons either in 1) absolute numbers based on the polygon coordinates, 2) proportional numbers, 3) normalized numbers and 4) squared units (e.g. kilometers).
}
\details{
To approximate the sizes in squared units, either the \code{total.area} or the \code{unit.size} is required. Note that this method is an approximation, since it depends on the used projection and the level of detail of the SpatialPolygons object. Projections with equal-area property are highly recommended.
}
\examples{
data(NLD_muni)

NLD_muni$area <- approx_areas(NLD_muni, total.area = 33893)

tm_shape(NLD_muni) +
	tm_bubbles(size="area", title.size=expression("Area in " * km^2))
}

