\name{GoogleReaderSource}
\alias{GoogleReaderSource}
\alias{readGoogleReader}
\title{Retrieve feeds through the Google Reader API.}
\usage{
  GoogleReaderSource(feed,
    auth.token = auth.google.reader(),
    params = list(n = 100), curlOpts = NULL, ...)
}
\arguments{
  \item{feed}{url of feed to be retrieved through the
  Google Reader API}

  \item{auth.token}{Authentification token as retrieved
  from \code{\link{auth.google.reader}}}

  \item{params}{Additional parameters for Google Reader
  API, n (number of items) is already set to 100 (see also
  note).}

  \item{curlOpts}{RCurl options (as generated by
  \code{\link{curlOptions}}). Defaults to NULL (are
  therefore auto-generated).}

  \item{...}{additional parameters to be used in
  \code{\link{WebSource}}}
}
\description{
  This function utilizes the (unofficial) Google Reader API
  to retrieve RSS feeds. The advantage of access RSS feeds
  through the Google Reader API is that you are not limited
  by the number of entries a website may included in their
  feed. That is, Google maintains generally maintains a
  complete history of entries from the RSS feed. Code was
  partly taken from Jason Bryer
  \url{http://bryer.org/2012/retrieving-rss-feeds-using-google-reader}
  Note that the contents of the results will be limited by
  what the website provides in their feeds. That is, Google
  does not contain more information per entry then what the
  website originally provided. If the initial feed
  contained only excerpts of the article, the feed from
  Google will too only contain excerpts. Be aware though
  that for sites that do provide the complete contents of
  posts will result in potentially very large downloads.
}
\note{
  Number of items (n, through params) can be set to a much
  larger number (>1000), depending on the number of feed
  items cached in Google Reader. However, large request can
  take a lot of time/memory.

  Currently, \code{\link{corpus.update}} is not supported
  for GoogleReaderSource
}
\author{
  Mario Annau
}

