% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num_compare.R
\name{num_compare}
\alias{num_compare}
\title{Compare a numerical variable across levels of a categorical variable}
\usage{
num_compare(y, grp, plot = c("density", "boxplot", "none"))
}
\arguments{
\item{y}{A numerical variable}

\item{grp}{A categorical variable}

\item{plot}{Type of plot to produce}
}
\value{
Returns a list including (1) group-wise summary statistics, (2) ANOVA decomposition, (3) eta-squared effect size, and (4) ggplot2 object, if requested.
}
\description{
\code{num_compare} gives details about the distribution of a numeric variable across subsets of the dataset
}
\examples{
v1 = rbinom(n=50, size=1, p=0.5)
v2 = rnorm(50)
num_compare(y=v2, grp=v1, plot='density')

}
