% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_value.R
\name{r_value}
\alias{r_value}
\title{Robustness value}
\usage{
r_value(effect_observed, se, df, ...)
}
\arguments{
\item{effect_observed}{Numeric. Observed exposure - outcome effect from a
regression model. This is the point estimate (beta coefficient)}

\item{se}{Numeric. Standard error of the \code{effect_observed} in the previous parameter.}

\item{df}{Numeric positive value. Residual degrees of freedom for the model
used to estimate the observed exposure - outcome effect. This is the total
number of observations minus the number of parameters estimated in your
model. Often for models estimated with an intercept this is N - k - 1
where k is the number of predictors in the model.}

\item{...}{Optional arguments passed to the \code{\link[sensemakr:robustness_value]{sensemakr::robustness_value()}}
function.}
}
\value{
Numeric. Robustness value
}
\description{
This function wraps the \code{\link[sensemakr:robustness_value]{sensemakr::robustness_value()}} function
}
\examples{
r_value(0.5, 0.1, 102)
}
\references{
Carlos Cinelli, Jeremy Ferwerda and Chad Hazlett (2021).
sensemakr: Sensitivity Analysis
Tools for Regression Models. R package version 0.1.4.
https://CRAN.R-project.org/package=sensemakr
}
