% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atomic_conversions.R
\name{atomic_conversions}
\alias{atomic_conversions}
\alias{as_bool}
\alias{as_int}
\alias{as_dbl}
\alias{as_chr}
\title{Atomic Type Casting Without Stripping Attributes}
\usage{
as_bool(x, ...)

as_int(x, ...)

as_dbl(x, ...)

as_chr(x, ...)
}
\arguments{
\item{x}{vector, matrix, array
(or a similar object where all elements share the same type).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The converted object.
}
\description{
Atomic type casting in R is generally performed using the functions
\link[base]{as.logical}, \link[base]{as.integer}, \link[base]{as.double},
\link[base]{as.character}. \cr
\cr
Converting an object between atomic types using these functions
strips the object of its attributes,
including attributes such as names and dimensions. \cr
\cr
The functions provided here by the 'tinycodet' package
preserve all attributes - except the "class" attribute. \cr
\cr
The functions are as follows: \cr
\itemize{
\item \code{as_bool()}: converts object to atomic type \code{logical} (\code{TRUE, FALSE, NA}).
\item \code{as_int()}: converts object to atomic type \code{integer}.
\item \code{as_dbl()}: converts object to atomic type \code{double} (AKA decimal numbers).
\item \code{as_chr()}: converts object to atomic type \code{character}.
}
}
\examples{
x <- c(rep(0, 2), seq(0, 2.5, by=0.5)) |> matrix(ncol=2)
colnames(x) <- c("one", "two")
attr(x, "test") <- "test"
print(x)

# notice that in all following, attributes (except class) are conserved:
as_bool(x)
as_int(x)
as_dbl(x)
as_chr(x)




}
\seealso{
\link{tinycodet_safer}
}
