% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_survival_cut_cox_km.R
\name{surv_cox}
\alias{surv_cox}
\title{surv_cox}
\usage{
surv_cox(
  exprSet_hub,
  meta,
  cut.point = FALSE,
  pvalue_cutoff = 0.05,
  HRkeep = "all",
  continuous = FALSE,
  min_gn = 0.1
)
}
\arguments{
\item{exprSet_hub}{a tumor expression set for hubgenes}

\item{meta}{meta data corresponds to expression set}

\item{cut.point}{logical , use cut_point or not, if FALSE,use median by defult}

\item{pvalue_cutoff}{p value cut off ,0.05 by defult}

\item{HRkeep}{one of "all","protect"or"risk"}

\item{continuous}{logical, gene expression or gene expression group}

\item{min_gn}{Depending on the expression of a gene, there may be a large difference in the number of samples between the two groups, and if a smaller group of samples is less than 10 percent (default) of all, the gene will be discarded}
}
\value{
a matrix with gene names ,cox p value and HR
}
\description{
calculate cox p values and HR for genes
}
\examples{
surv_cox(exprSet_hub1,meta1,cut.point = TRUE,HRkeep = "all")
}
\seealso{
\code{\link{point_cut}};\code{\link{surv_KM}}
}
\author{
Xiaojie Sun
}
