% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-slice_period.R
\name{slice_period}
\alias{slice_period}
\title{Apply slice inside periods (windows)}
\usage{
slice_period(.data, ..., .date_var, .period = "1 day")
}
\arguments{
\item{.data}{A \code{tbl} object or \code{data.frame}}

\item{...}{For \code{slice()}: <\code{\link[rlang:args_data_masking]{data-masking}}>
Integer row values.

Provide either positive values to keep, or negative values to drop.
The values provided must be either all positive or all negative.
Indices beyond the number of rows in the input are silently ignored.

For \verb{slice_*()}, these arguments are passed on to methods.}

\item{.date_var}{A column containing date or date-time values.
If missing, attempts to auto-detect date column.}

\item{.period}{A period to slice within.
Time units are grouped using \code{lubridate::floor_date()} or \code{lubridate::ceiling_date()}.

The value can be:
\itemize{
\item \code{second}
\item \code{minute}
\item \code{hour}
\item \code{day}
\item \code{week}
\item \code{month}
\item \code{bimonth}
\item \code{quarter}
\item \code{season}
\item \code{halfyear}
\item \code{year}
}

Arbitrary unique English abbreviations as in the \code{lubridate::period()} constructor are allowed:
\itemize{
\item \code{"1 year"}
\item \code{"2 months"}
\item \code{"30 seconds"}
}}
}
\value{
A \code{tibble} or \code{data.frame}
}
\description{
Applies a dplyr slice inside a time-based period (window).
}
\examples{
# Libraries
library(dplyr)

# First 5 observations in each month
m4_daily \%>\%
    group_by(id) \%>\%
    slice_period(1:5, .period = "1 month")

# Last observation in each month
m4_daily \%>\%
    group_by(id) \%>\%
    slice_period(n(), .period = "1 month")

}
\seealso{
Time-Based dplyr functions:
\itemize{
\item \code{\link[=summarise_by_time]{summarise_by_time()}} - Easily summarise using a date column.
\item \code{\link[=mutate_by_time]{mutate_by_time()}} - Simplifies applying mutations by time windows.
\item \code{\link[=pad_by_time]{pad_by_time()}} - Insert time series rows with regularly spaced timestamps
\item \code{\link[=filter_by_time]{filter_by_time()}} - Quickly filter using date ranges.
\item \code{\link[=filter_period]{filter_period()}} - Apply filtering expressions inside periods (windows)
\item \code{\link[=slice_period]{slice_period()}} - Apply slice inside periods (windows)
\item \code{\link[=condense_period]{condense_period()}} - Convert to a different periodicity
\item \code{\link[=between_time]{between_time()}} - Range detection for date or date-time sequences.
\item \code{\link[=slidify]{slidify()}} - Turn any function into a sliding (rolling) function
}
}
