% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-time_series_regression.R
\name{plot_time_series_regression}
\alias{plot_time_series_regression}
\title{Visualize a Time Series Linear Regression Formula}
\usage{
plot_time_series_regression(
  .data,
  .date_var,
  .formula,
  .show_summary = FALSE,
  ...
)
}
\arguments{
\item{.data}{A \code{tibble} or \code{data.frame} with a time-based column}

\item{.date_var}{A column containing either date or date-time values}

\item{.formula}{A linear regression formula. The left-hand side of the formula is used
as the y-axis value. The right-hand side of the formula is used to develop the linear regression model.
See \code{\link[stats:lm]{stats::lm()}} for details.}

\item{.show_summary}{If \code{TRUE}, prints the \code{summary.lm()}.
Only available for non-grouped data.}

\item{...}{Additional arguments passed to \code{\link[=plot_time_series]{plot_time_series()}}}
}
\value{
A static \code{ggplot2} plot or an interactive \code{plotly} plot
}
\description{
A wrapper for \code{\link[stats:lm]{stats::lm()}} that overlays a
linear regression fitted model over a time series, which can help
show the effect of feature engineering
}
\details{
\code{plot_time_series_regression()} is a scalable function that works with both \emph{ungrouped} and \emph{grouped}
\code{data.frame} objects (and \code{tibbles}!).

\strong{Time Series Formula}

The \code{.formula} uses \code{\link[stats:lm]{stats::lm()}} to apply a linear regression, which is used to visualize
the effect of feature engineering on a time series.
\itemize{
\item The left-hand side of the formula is used as the y-axis value.
\item The right-hand side of the formula is used to develop the linear regression model.
}

\strong{Interactive by Default}

\code{plot_time_series_regression()} is built for exploration using:
\itemize{
\item \strong{Interactive Plots:} \code{plotly} (default) - Great for exploring!
\item \strong{Static Plots:} \code{ggplot2} (set \code{.interactive = FALSE}) - Great for PDF Reports
}

By default, an interactive \code{plotly} visualization is returned.

\strong{Scalable with Facets & Dplyr Groups}

\code{plot_time_series_regression()} returns multiple time series plots using \code{ggplot2} facets:
\itemize{
\item \code{group_by()} - If groups are detected, multiple facets are returned
\item \code{plot_time_series_regression(.facet_vars)} - You can manually supply facets as well.
}
}
\examples{
library(dplyr)
library(lubridate)

# ---- SINGLE SERIES ----
m4_monthly \%>\%
    filter(id == "M750") \%>\%
    plot_time_series_regression(
        .date_var     = date,
        .formula      = log(value) ~ as.numeric(date) + month(date, label = TRUE),
        .show_summary = TRUE,
        .facet_ncol   = 2,
        .interactive  = FALSE
    )


# ---- GROUPED SERIES ----
m4_monthly \%>\%
    group_by(id) \%>\%
    plot_time_series_regression(
        .date_var    = date,
        .formula     = log(value) ~ as.numeric(date) + month(date, label = TRUE),
        .facet_ncol  = 2,
        .interactive = FALSE
    )


}
