% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTables.R
\name{createTimeseriesMain}
\alias{createTimeseriesMain}
\alias{createTimeseriesVintages}
\alias{createTimeseriesSets}
\alias{createMetaUnlocalized}
\alias{createMetaLocalized}
\alias{createMetaDatasets}
\title{Create Statements for PostgreSQL tables}
\usage{
createTimeseriesMain(schema = "timeseries", tbl = "timeseries_main")

createTimeseriesVintages(schema = "timeseries", tbl = "timeseries_vintages")

createTimeseriesSets(schema = "timeseries", tbl = "timeseries_sets")

createMetaUnlocalized(schema = "timeseries", tbl = "meta_data_unlocalized",
  main = "timeseries_main")

createMetaLocalized(schema = "timeseries", tbl = "meta_data_localized",
  main = "timeseries_main")

createMetaDatasets(schema = "timeseries", tbl = "meta_datasets")
}
\arguments{
\item{schema}{character denoting a PostgreSQL schema}

\item{tbl}{character denoting a table name}

\item{main}{character denoting name of the main table for referencing. This argument is only available to meta data statements.}
}
\description{
These function creates statements to set up 5 Tables used to manage and archive time series information in PostgreSQL.
Make sure you have sufficient rights to create relations in your PostgreSQL schema. These function are only used for an initial setup. You can either run this group of functions separately or use \code{\link{runCreateTables}} to 
run all functions at once.
}
\details{
The following tables will be create in the given schema.
\itemize{
 \item{"timeseries_main"}{contains time series themselves as hstore key value pairs.}
 \item{"timeseries_vintages"}{contains vintages of time series.
  This is useful for published data that can be revised. see also OECD defintion of vintages}
 \item{"timeseries_sets"}{contains a vector of time series keys. This table can be used like a shopping cart in an e-commerce application. }
 \item{"meta_data_unlocalized"}{contains translation agnostic meta information, e.g., username.}
 \item{"meta_data_localized"}{contains translation specific meta information, e.g., wording of a question.}
}
}
\references{
OECD Defintion of vintages: \url{http://www.oecd.org/std/40315408.pdf}
}
