% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_wikipedia_page_qid.R
\name{tw_get_wikipedia_base_api_url}
\alias{tw_get_wikipedia_base_api_url}
\title{Facilitates the creation of MediaWiki API base URLs}
\usage{
tw_get_wikipedia_base_api_url(
  url = NULL,
  title = NULL,
  language = tidywikidatar::tw_get_language(),
  action = "query",
  type = "page"
)
}
\arguments{
\item{url}{A character vector with the full URL to one or more Wikipedia pages. If given, title and language can be left empty.}

\item{title}{Title of a Wikipedia page or final parts of its url. If given, url can be left empty, but language must be provided.}

\item{language}{Two-letter language code used to define the Wikipedia version to use. Defaults to language set with \code{tw_set_language()}; if not set, "en". If url given, this can be left empty.}

\item{action}{Defaults to "query". Usually either "query" or "parse". In principle, any valid action value, see: \url{https://www.mediawiki.org/w/api.php}}

\item{type}{Defaults to "page". Either "page" or "category".}
}
\value{
A character vector of base urls to be used with the MediaWiki API
}
\description{
Mostly used internally
}
\examples{
tw_get_wikipedia_base_api_url(title = "Margaret Mead", language = "en")
tw_get_wikipedia_base_api_url(
  title = "Category:American women anthropologists",
  type = "category",
  language = "en"
)
}
