% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_extract.R
\name{tw_extract_single}
\alias{tw_extract_single}
\title{Extract item data from an object of class Wikidata created with \code{WikidataR}}
\usage{
tw_extract_single(w, language = tidywikidatar::tw_get_language())
}
\arguments{
\item{w}{An object of class Wikidata created with \code{WikidataR}, typically created with \code{WikidataR::get_item(id = id)}}

\item{language}{Defaults to language set with \code{tw_set_language()}; if not set, "en". Use "all_available" to keep all languages. For available language values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}
}
\value{
A data frame (a tibble) with four columns, such as the one created by \code{tw_get}.
}
\description{
This function is mostly used internally and for testing.
}
\examples{
item <- tryCatch(WikidataR::get_item(id = "Q180099"),
  error = function(e) {
    as.character(e[[1]])
  }
)

tidywikidatar:::tw_extract_single(w = item)
}
