% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_qualifiers.R
\name{tw_write_qualifiers_to_cache}
\alias{tw_write_qualifiers_to_cache}
\title{Write qualifiers to cache}
\usage{
tw_write_qualifiers_to_cache(
  id,
  p,
  qualifiers_df,
  language = "all_available",
  overwrite_cache = FALSE
)
}
\arguments{
\item{id}{A characther vector, must start with Q, e.g. "Q180099" for the anthropologist Margaret Mead. Can also be a data frame of one row, typically generated with \code{tw_search()} or a combination of \code{tw_search()} and \code{tw_filter_first()}.}

\item{p}{A character vector of length 1, a property. Must always start with the capital letter "P", e.g. "P31" for "instance of".}

\item{qualifiers_df}{A data frame with two columns typically generated with \code{tw_get(include_id_and_p = FALSE)}.}

\item{language}{Defaults to "all_available". By default, returns dataset with labels in all available languages. If given, only in the chosen language. For available values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{overwrite_cache}{Logical, defaults to FALSE. If TRUE, it overwrites the table in the local sqlite database. Useful if the original Wikidata object has been updated.}
}
\value{
Silently returns the same data frame provided as input. Mostly used internally for its side effects.
}
\description{
Mostly to be used internally by \code{tidywikidatar}, use with caution to keep caching consistent.
}
\examples{

q_df <- tw_get_qualifiers(
  id = "Q180099",
  p = "P26",
  language = "en",
  cache = FALSE,
  include_id = FALSE
)
tw_write_qualifiers_to_cache(
  id = "Q180099",
  p = "P26",
  qualifiers_df = q_df,
  language = "en"
)
}
