#' Checks if an input is a search; if not, it tries to return a search
#'
#' Mostly used as a convenience function inside other functions to have consistent inputs.
#'
#' @param search A data frame generated by `tw_search()`, or a search query. If a data frame is given, language and limits are ignore.
#' @param language Language to be used for the search.
#' @param limit Maximum numbers of responses to be given.
#' @param cache Logical, defaults to TRUE.
#' @param wait In seconds, defaults to 0.1. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied.
#'
#' @return A data frame with three columns, `id`, `label`, and `description`, filtered by the above criteria.
#' @export
#'
#' @examples
#' # The following two lines should give the same result.
#'
#' tw_check_search("Sylvia Pankhurst")
#' tw_check_search(tw_search("Sylvia Pankhurst"))
tw_check_search <- function(search,
                            language = "en",
                            limit = 10,
                            wait = 0,
                            cache = NULL) {
  if (is.data.frame(search) == TRUE) {
    search_result <- search
  } else if (length(search) > 1) {
    usethis::ui_stop("Input must be a single query or a data frame generated by `tw_search()`")
  } else if (is.character(search) == TRUE) {
    search_result <- tidywikidatar::tw_search(
      search = search,
      language = language,
      limit = limit,
      wait = 1,
      cache = NULL
    )
  }
  search_result
}
