% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemdose_ph.R
\name{chemdose_ph}
\alias{chemdose_ph}
\title{Calculate new pH and ion balance after chemical addition}
\usage{
chemdose_ph(
  water,
  hcl = 0,
  h2so4 = 0,
  h3po4 = 0,
  co2 = 0,
  naoh = 0,
  caoh2 = 0,
  mgoh2 = 0,
  na2co3 = 0,
  nahco3 = 0,
  caco3 = 0,
  cacl2 = 0,
  cl2 = 0,
  naocl = 0,
  nh4oh = 0,
  nh42so4 = 0,
  alum = 0,
  ferricchloride = 0,
  ferricsulfate = 0,
  ach = 0,
  softening_correction = FALSE
)
}
\arguments{
\item{water}{Source water object of class "water" created by \code{\link{define_water}}}

\item{hcl}{Amount of hydrochloric acid added in mg/L: HCl -> H + Cl}

\item{h2so4}{Amount of sulfuric acid added in mg/L: H2SO4 -> 2H + SO4}

\item{h3po4}{Amount of phosphoric acid added in mg/L: H3PO4 -> 3H + PO4}

\item{co2}{Amount of carbon dioxide added in mg/L: CO2 (gas) + H2O -> H2CO3*}

\item{naoh}{Amount of caustic added in mg/L: NaOH -> Na + OH}

\item{caoh2}{Amount of lime added in mg/L: Ca(OH)2 -> Ca + 2OH}

\item{mgoh2}{Amount of magneisum hydroxide added in mg/L: Mg(OH)2 -> Mg + 2OH}

\item{na2co3}{Amount of soda ash added in mg/L: Na2CO3 -> 2Na + CO3}

\item{nahco3}{Amount of sodium bicarbonate added in mg/L: NaHCO3 -> Na + H + CO3}

\item{caco3}{Amount of calcium carbonate added (or removed) in mg/L: CaCO3 -> Ca + CO3}

\item{cacl2}{Amount of calcium chloride added in mg/L: CaCl2 -> Ca2+ + 2Cl-}

\item{cl2}{Amount of chlorine gas added in mg/L as Cl2: Cl2(g) + H2O -> HOCl + H + Cl}

\item{naocl}{Amount of sodium hypochlorite added in mg/L as Cl2: NaOCl -> Na + OCl}

\item{nh4oh}{Amount of ammonium hydroxide added in mg/L as N: NH4OH -> NH4 + OH}

\item{nh42so4}{Amount of ammonium sulfate added in mg/L as N: (NH4)2SO4 -> 2NH4 + SO4}

\item{alum}{Amount of hydrated aluminum sulfate added in mg/L: Al2(SO4)3*14H2O + 6HCO3 -> 2Al(OH)3(am) +3SO4 + 14H2O + 6CO2}

\item{ferricchloride}{Amount of ferric Chloride added in mg/L: FeCl3 + 3HCO3 -> Fe(OH)3(am) + 3Cl + 3CO2}

\item{ferricsulfate}{Amount of ferric sulfate added in mg/L: Fe2(SO4)3*8.8H2O + 6HCO3 -> 2Fe(OH)3(am) + 3SO4 + 8.8H2O + 6CO2}

\item{ach}{Amount of aluminum chlorohydrate added in mg/L: Al2(OH)5Cl*2H2O + HCO3 -> 2Al(OH)3(am) + Cl + 2H2O + CO2}

\item{softening_correction}{Set to TRUE to correct post-softening pH (caco3 must be < 0). Default is FALSE. Based on WTP model equation 5-62}
}
\value{
A water class object with updated pH, alkalinity, and ions post-chemical addition.
}
\description{
\code{chemdose_ph} calculates the new pH, alkalinity, and ion balance of a water based on different chemical
additions.
}
\details{
The function takes an object of class "water" created by \code{\link{define_water}} and user-specified
chemical additions and returns a new object of class "water" with updated water quality.
Units of all chemical additions are in mg/L as chemical (not as product).

\code{chemdose_ph} works by evaluating all the user-specified chemical additions and solving for what the new pH
must be using \code{uniroot} to satisfy the principle of electroneutrality in pure water while correcting for the existing alkalinity
of the water that the chemical is added to. Multiple chemicals can be added simultaneously or each addition can be
modeled independently through sequential doses.
}
\examples{
water <- define_water(ph = 7, temp = 25, alk = 10)
# Dose 1 mg/L of hydrochloric acid
dosed_water <- chemdose_ph(water, hcl = 1)
dosed_water@ph

# Dose 1 mg/L of hydrochloric acid and 5 mg/L of alum simultaneously
dosed_water <- chemdose_ph(water, hcl = 1, alum = 5)
dosed_water@ph

# Dose 1 mg/L of hydrochloric acid and 5 mg/L of alum sequentially
dosed_water1 <- chemdose_ph(water, hcl = 1)
dosed_water1@ph
dosed_water2 <- chemdose_ph(dosed_water1, alum = 5)
dosed_water2@ph

# Softening:
water2 <- define_water(ph = 7, temp = 25, alk = 100, tot_hard = 350)
dosed_water1 <- chemdose_ph(water2, caco3 = -100)
dosed_water1@ph
dosed_water2 <- chemdose_ph(water2, caco3 = -100, softening_correction = TRUE)
dosed_water2@ph

}
\seealso{
\code{\link{define_water}}, \code{\link{convert_units}}
}
