% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biofilter_toc.R
\name{biofilter_toc}
\alias{biofilter_toc}
\title{Determine TOC removal from biofiltration using Terry & Summers BDOC model}
\source{
Terry and Summers 2018
}
\usage{
biofilter_toc(water, ebct, ozonated = TRUE)
}
\arguments{
\item{water}{Source water object of class "water" created by \code{\link{define_water}}.}

\item{ebct}{The empty bed contact time (min) used for the biofilter}

\item{ozonated}{Logical; TRUE if the water is ozonated (default), FALSE otherwise}
}
\value{
A water class object with modeled DOC removal from biofiltration.
}
\description{
This function applies the Terry model to a water created by \code{\link{define_water}} to determine biofiltered
DOC (mg/L).
}
\examples{
library(tidywater)
water <- define_water(ph = 7, temp = 25, alk = 100, toc = 5.0, doc = 4.0, uv254 = .1) \%>\%
  biofilter_toc(ebct = 10, ozonated = FALSE)

}
