% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats.R
\name{bininfo}
\alias{bininfo}
\alias{bininfo.tidyvpcobj}
\title{Obtain information about the bins from a VPC object.}
\usage{
bininfo(o, ...)

\method{bininfo}{tidyvpcobj}(o, by.strata = o$bin.by.strata, ...)
}
\arguments{
\item{o}{An object.}

\item{...}{Additional arguments.}

\item{by.strata}{Should the calculations be done by strata? Defaults to what
was specified when the binning was done.}
}
\value{
A `data.table` containing the following columns:
\itemize{
  \item \code{nobs}: the number of observed data points in the bin
  \item \code{xmedian}: the median x-value of the observed data points in the bin
  \item \code{xmean}: the mean x-value of the observed data points in the bin
  \item \code{xmax}: the maximum x-value of the observed data points in the bin
  \item \code{xmin}: the minimum x-value of the observed data points in the bin
  \item \code{xmid}: the value halfway between `xmin` and `xmax`.
  x-value of the observed data points in the bin
  \item \code{xleft}: the value halfway between the minimum x-value of the
  current bin and the maximum x-value of the previous bin to the left (for
  the left-most bin it is the minimum x-value).
  \item \code{xright}: the value halfway between the maximum x-value of the
  current bin and the minimum x-value of the next bin to the right (for the
  right-most bin it is the maximum x-value).
  \item \code{xcenter}: the value halfway between `xleft` and `xright`.
}
In addition, if statification was performed, the stratification columns will
be included as well.
}
\description{
Obtain information about the bins from a VPC object.
}
\section{Methods (by class)}{
\itemize{
\item \code{tidyvpcobj}: Method for \code{tidyvpcobj}.
}}

