% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequencies.R
\name{get_stop_frequency}
\alias{get_stop_frequency}
\title{Get Stop Frequency}
\usage{
get_stop_frequency(
  gtfs_obj,
  start_hour = 6,
  end_hour = 22,
  service_ids = c(),
  dow = c(1, 1, 1, 1, 1, 0, 0),
  by_route = TRUE,
  wide = FALSE
)
}
\arguments{
\item{gtfs_obj}{a list of gtfs dataframes as read by \code{\link[=read_gtfs]{read_gtfs()}}.}

\item{start_hour}{(optional) an integer indicating the start hour (default 6)}

\item{end_hour}{(optional) an integer indicating the end hour (default 22)}

\item{service_ids}{(optional) a set of service_ids from the calendar dataframe identifying a particular service id}

\item{dow}{(optional) integer vector indicating which days of week to calculate for. default is weekday, e.g. c(1,1,1,1,1,0,0)}

\item{by_route}{default TRUE, if FALSE then calculate headway for any line coming through the stop in the same direction on the same schedule.}

\item{wide}{(optional) if true, then return a wide rather than tidy data frame}
}
\value{
dataframe of stops with the number of departures and the headway
(departures divided by timespan) as columns.
}
\description{
Note that some GTFS feeds contain a frequency data frame already.
Consider using this instead, as it will be more accurate than what
tidytransit calculates.
}
\examples{
data(gtfs_duke)
stop_frequency <- get_stop_frequency(gtfs_duke)
x <- order(stop_frequency$headway)
head(stop_frequency[x,])
}
