% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join-SpatVector.R
\name{filter-joins.SpatVector}
\alias{filter-joins.SpatVector}
\alias{semi_join.SpatVector}
\alias{anti_join.SpatVector}
\title{Filtering joins for SpatVectors}
\usage{
\method{semi_join}{SpatVector}(x, y, by = NULL, copy = FALSE, ...)

\method{anti_join}{SpatVector}(x, y, by = NULL, copy = FALSE, ...)
}
\arguments{
\item{x}{A SpatVector created with \code{\link[terra:vect]{terra::vect()}}.}

\item{y}{A data frame or other object coercible to a data frame. \strong{If a
SpatVector of sf object} is provided it would return an error (see
\code{\link[terra:intersect]{terra::intersect()}} for performing spatial joins).}

\item{by}{A join specification created with \code{\link[dplyr:join_by]{join_by()}}, or a character
vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so
that you can check they're correct; suppress the message by supplying \code{by}
explicitly.

To join on different variables between \code{x} and \code{y}, use a \code{\link[dplyr:join_by]{join_by()}}
specification. For example, \code{join_by(a == b)} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a \code{\link[dplyr:join_by]{join_by()}} specification with
multiple expressions. For example, \code{join_by(a == b, c == d)} will match
\code{x$a} to \code{y$b} and \code{x$c} to \code{y$d}. If the column names are the same between
\code{x} and \code{y}, you can shorten this by listing only the variable names, like
\code{join_by(a, c)}.

\code{\link[dplyr:join_by]{join_by()}} can also be used to perform inequality, rolling, and overlap
joins. See the documentation at \link[dplyr:join_by]{?join_by} for details on
these types of joins.

For simple equality joins, you can alternatively specify a character vector
of variable names to join by. For example, \code{by = c("a", "b")} joins \code{x$a}
to \code{y$a} and \code{x$b} to \code{y$b}. If variable names differ between \code{x} and \code{y},
use a named character vector like \code{by = c("x_a" = "y_a", "x_b" = "y_b")}.

To perform a cross-join, generating all combinations of \code{x} and \code{y}, see
\code{\link[dplyr:cross_join]{cross_join()}}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{...}{Other parameters passed onto methods.}
}
\value{
A SpatVector object.
}
\description{
Filtering joins filter rows from \code{x} based on the presence or absence of
matches in \code{y}:
\itemize{
\item \code{\link[=semi_join]{semi_join()}} return all rows from \code{x} with a match in \code{y}.
\item \code{\link[=anti_join]{anti_join()}} return all rows from \code{x} without a match in \code{y}.
}

See \code{\link[dplyr:filter-joins]{dplyr::semi_join()}} for details.
}
\section{terra equivalent}{


\code{\link[terra:merge]{terra::merge()}}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[dplyr:filter-joins]{dplyr::semi_join()}} family
\subsection{SpatVector}{

The geometry column has a sticky behavior. This means that the result would
have always the geometry of \code{x} for the records that matches the join
conditions.
}
}

\examples{
library(terra)
library(ggplot2)

# Vector
v <- terra::vect(system.file("extdata/cyl.gpkg", package = "tidyterra"))

# A data frame
df <- data.frame(
  cpro = sprintf("\%02d", 1:10),
  x = runif(10),
  y = runif(10),
  letter = rep_len(LETTERS[1:3], length.out = 10)
)

v

# Semi join
semi <- v \%>\% semi_join(df)

semi

autoplot(semi, aes(fill = iso2)) + ggtitle("Semi Join")


# Anti join

anti <- v \%>\% anti_join(df)

anti

autoplot(anti, aes(fill = iso2)) + ggtitle("Anti Join")

}
\seealso{
\code{\link[dplyr:filter-joins]{dplyr::semi_join()}}, \code{\link[dplyr:filter-joins]{dplyr::anti_join()}}, \code{\link[terra:merge]{terra::merge()}}

Other dplyr verbs that operate on pairs Spat*/data.frame:
\code{\link{bind_cols.SpatVector}},
\code{\link{bind_rows.SpatVector}},
\code{\link{mutate-joins.SpatVector}}

Other dplyr methods:
\code{\link{arrange.SpatVector}()},
\code{\link{bind_cols.SpatVector}},
\code{\link{bind_rows.SpatVector}},
\code{\link{count.SpatVector}()},
\code{\link{distinct.SpatVector}()},
\code{\link{filter.Spat}},
\code{\link{glimpse.Spat}},
\code{\link{group-by.SpatVector}},
\code{\link{mutate-joins.SpatVector}},
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{rowwise.SpatVector}()},
\code{\link{select.Spat}},
\code{\link{slice.Spat}},
\code{\link{summarise.SpatVector}()}
}
\concept{dplyr.methods}
\concept{dplyr.pairs}
