% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{group_by}
\alias{group_by}
\title{Group by one or more variables}
\usage{
group_by(.data, ..., .add = FALSE, .drop = group_by_drop_default(.data))
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See *Methods*, below, for
more details.}

\item{...}{In `group_by()`, variables or computations to group by.
In `ungroup()`, variables to remove from the grouping.}

\item{.add}{When `FALSE`, the default, `group_by()` will
  override existing groups. To add to the existing groups, use
  `.add = TRUE`.

  This argument was previously called `add`, but that prevented
  creating a new grouping variable called `add`, and conflicts with
  our naming conventions.}

\item{.drop}{When `.drop = TRUE`, empty groups are dropped. See [group_by_drop_default()] for
what the default value is for this argument.}
}
\value{
A [grouped data frame][grouped_df()], unless the combination of `...` and `add`
  yields a non empty set of grouping columns, a regular (ungrouped) data frame
  otherwise.
}
\description{
Most data operations are done on groups defined by variables.
`group_by()` takes an existing tbl and converts it into a grouped tbl
where operations are performed "by group". `ungroup()` removes grouping.
}
\section{Methods}{

These function are **generic**s, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

Methods available in currently loaded packages:
}

\examples{
`\%>\%` = magrittr::`\%>\%`
pbmc_small \%>\% tidy \%>\% group_by(groups)

}
\concept{grouping functions}
