% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_spatial_initial_split.R
\name{autoplot.spatial_initial_split}
\alias{autoplot.spatial_initial_split}
\title{Create a ggplot for a spatial initial rsplit.}
\usage{
\method{autoplot}{spatial_initial_split}(object, ..., alpha = 0.6)
}
\arguments{
\item{object}{A \code{spatial_initial_rsplit} object.
Note that only resamples made from
\code{sf} objects  create \code{spatial_initial_rsplit} objects;
this function will not work for
resamples made with non-spatial tibbles or data.frames.}

\item{...}{Options passed to \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}.}

\item{alpha}{Opacity, passed to \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}.
Values of alpha range from 0 to 1, with lower values corresponding to more
transparent colors.}
}
\value{
A ggplot object with each fold assigned a color, made using
\code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}.
}
\description{
This method provides a good visualization method for a spatial
initial rsplit.
}
\details{
This plot method is a wrapper around the standard \code{spatial_rsplit} method,
but it re-labels the folds as \emph{Testing} and \emph{Training} following the
convention for a standard \code{initial_split} object
}
\examples{

set.seed(123)
block_initial <- spatial_initial_split(boston_canopy,
  prop = 1 / 5, spatial_block_cv
)
autoplot(block_initial)
}
