% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_plate.R
\name{tidy_plate}
\alias{tidy_plate}
\title{Reads and transforms microwell plate to a tibble}
\usage{
tidy_plate(file, well_id = "well", sheet = 1)
}
\arguments{
\item{file}{A character string containing the path to a csv or excel file.
The format is described below.}

\item{well_id}{A character string that will be the name for the well id
column.}

\item{sheet}{A character or integer indicating the excel sheet to be
read.}
}
\value{
A tibble.
}
\description{
Reads and transforms microwell plate to a tibble
}
\examples{
file_path <- system.file("extdata", "example_12_well.xlsx",
  package = "tidyplate"
)

data_12 <- tidy_plate(file = file_path)

head(data_12)
}
