% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_start_event}
\alias{create_start_event}
\title{Create a start event column.}
\usage{
create_start_event(tibble, series_col)
}
\arguments{
\item{tibble}{A tibble arranged according to the series.}

\item{series_col}{The name of the column that defines the group of series, as an unquoted expression.}
}
\value{
A tibble with an extra column that marks the beginning of the series.
}
\description{
Create a new column which marks the beginning of each series in a tibble (for example, time series).
}
\examples{
library(dplyr)
series_tbl <- tibble(
  time_series = rep(1:5, 3),
  group = rep(c("a", "b", "c"), each = 5)
) \%>\%
  create_start_event(group)

}
