% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy_annual_stats.R
\name{hy_annual_stats}
\alias{hy_annual_stats}
\title{Extract annual statistics information from the HYDAT database}
\format{
A tibble with 8 variables:
\describe{
  \item{STATION_NUMBER}{Unique 7 digit Water Survey of Canada station number}
  \item{Parameter}{Parameter being measured. Only possible values are FLOW and LEVEL}
  \item{Year}{Year of record.}
  \item{Sum_stat}{Summary statistic being used.}
  \item{Value}{Value of the measurement. If Parameter equals FLOW the units are m^3/s. If Parameter equals LEVEL the
  units are metres.}
  \item{Date}{Observation date. Formatted as a Date class. MEAN is a annual summary
  and therefore has an NA value for Date.}
  \item{Symbol}{Measurement/river conditions}
}
}
\source{
HYDAT
}
\usage{
hy_annual_stats(
  station_number = NULL,
  hydat_path = NULL,
  prov_terr_state_loc = NULL,
  start_year = "ALL",
  end_year = "ALL"
)
}
\arguments{
\item{station_number}{A seven digit Water Survey of Canada station number. If this argument is omitted, the value of \code{prov_terr_state_loc}
is returned.}

\item{hydat_path}{The path to the hydat database or NULL to use the default location
used by \link{download_hydat}. It is also possible to pass in an existing 
\link[dplyr]{src_sqlite} such that the database only needs to be opened once per
user-level call.}

\item{prov_terr_state_loc}{Province, state or territory. If this argument is omitted, the value of \code{station_number}
is returned. See \code{unique(allstations$prov_terr_state_loc)}. Will also accept \code{CA} to return only Canadian stations.}

\item{start_year}{First year of the returned record}

\item{end_year}{Last year of the returned record}
}
\value{
A tibble of hy_annual_stats.
}
\description{
Provides wrapper to turn the ANNUAL_STATISTICS table in HYDAT into a tidy data frame of annual statistics.
Statistics provided include MEAN, MAX and MIN on an annual basis.
}
\examples{
\dontrun{
  ## Multiple stations province not specified
  hy_annual_stats(station_number = c("08NM083","05AE027"))

  ## Multiple province, station number not specified
  hy_annual_stats(prov_terr_state_loc = c("AB","SK"))
}

}
\seealso{
Other HYDAT functions: 
\code{\link{hy_agency_list}()},
\code{\link{hy_annual_instant_peaks}()},
\code{\link{hy_daily_flows}()},
\code{\link{hy_daily_levels}()},
\code{\link{hy_daily}()},
\code{\link{hy_data_symbols}},
\code{\link{hy_data_types}},
\code{\link{hy_datum_list}()},
\code{\link{hy_monthly_flows}()},
\code{\link{hy_monthly_levels}()},
\code{\link{hy_reg_office_list}()},
\code{\link{hy_sed_daily_loads}()},
\code{\link{hy_sed_daily_suscon}()},
\code{\link{hy_sed_monthly_loads}()},
\code{\link{hy_sed_monthly_suscon}()},
\code{\link{hy_sed_samples_psd}()},
\code{\link{hy_sed_samples}()},
\code{\link{hy_stations}()},
\code{\link{hy_stn_data_coll}()},
\code{\link{hy_stn_data_range}()},
\code{\link{hy_stn_op_schedule}()},
\code{\link{hy_stn_regulation}()},
\code{\link{hy_version}()}
}
\concept{HYDAT functions}
