% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy_sed_monthly_suscon.R
\name{hy_sed_monthly_suscon}
\alias{hy_sed_monthly_suscon}
\title{Extract monthly flows information from the HYDAT database}
\format{A tibble with 8 variables:
\describe{
  \item{STATION_NUMBER}{Unique 7 digit Water Survey of Canada station number}
  \item{Year}{Year of record.}
  \item{Month}{Numeric month value}
  \item{Full_Month}{Logical value is there is full record from Month}
  \item{No_days}{Number of days in that month}
  \item{Sum_stat}{Summary statistic being used.} 
  \item{Value}{Value of the measurement in mg/l.}
  \item{Date_occurred}{Observation date. Formatted as a Date class. MEAN is a annual summary 
  and therefore has an NA value for Date.}
}}
\source{
HYDAT
}
\usage{
hy_sed_monthly_suscon(station_number = NULL, hydat_path = NULL,
  prov_terr_state_loc = NULL, start_date = NULL, end_date = NULL)
}
\arguments{
\item{station_number}{A seven digit Water Survey of Canada station number. If this argument is omitted, the value of \code{prov_terr_state_loc}
is returned.}

\item{hydat_path}{The path to the hydat database or NULL to use the default location
used by \link{download_hydat}. It is also possible to pass in an existing 
\link[dplyr]{src_sqlite} such that the database only needs to be opened once per
user-level call.}

\item{prov_terr_state_loc}{Province, state or territory. If this argument is omitted, the value of \code{station_number}
is returned. See \code{unique(allstations$prov_terr_state_loc)}}

\item{start_date}{Leave blank if all dates are required. Date format needs to be in YYYY-MM-DD. Date is inclusive.}

\item{end_date}{Leave blank if all dates are required. Date format needs to be in YYYY-MM-DD. Date is inclusive.}
}
\value{
A tibble of monthly suspended sediment concentrations.
}
\description{
Tidy data of monthly suspended sediment concentration information from the SED_DLY_SUSCON HYDAT table.  \code{station_number} and
  \code{prov_terr_state_loc} can both be supplied. If both are omitted all values from the \code{hy_stations} table are returned.
  That is a large vector for \code{hy_sed_monthly_suscon}.
}
\examples{
\dontrun{
hy_sed_monthly_suscon(station_number = "08MF005")
          }
}
\seealso{
Other HYDAT functions: \code{\link{hy_agency_list}},
  \code{\link{hy_annual_instant_peaks}},
  \code{\link{hy_annual_stats}},
  \code{\link{hy_daily_flows}},
  \code{\link{hy_daily_levels}}, \code{\link{hy_daily}},
  \code{\link{hy_data_symbols}},
  \code{\link{hy_data_types}}, \code{\link{hy_datum_list}},
  \code{\link{hy_monthly_flows}},
  \code{\link{hy_monthly_levels}},
  \code{\link{hy_reg_office_list}},
  \code{\link{hy_sed_daily_loads}},
  \code{\link{hy_sed_daily_suscon}},
  \code{\link{hy_sed_monthly_loads}},
  \code{\link{hy_sed_samples_psd}},
  \code{\link{hy_sed_samples}}, \code{\link{hy_stations}},
  \code{\link{hy_stn_data_coll}},
  \code{\link{hy_stn_data_range}},
  \code{\link{hy_stn_op_schedule}},
  \code{\link{hy_stn_regulation}}, \code{\link{hy_version}}
}
\concept{HYDAT functions}
