% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_OLD.R
\docType{methods}
\name{gate}
\alias{gate}
\alias{gate.spec_tbl_df}
\alias{gate.tbl_df}
\title{DEPRECATED - use gate_chr, gate_int instead inside a dplyr::mutate() statement}
\usage{
gate(
  .data,
  .element,
  .dim1,
  .dim2,
  .color = NULL,
  .shape = NULL,
  .size = NULL,
  opacity = 1,
  how_many_gates = 1,
  gate_list = NULL,
  name = "gate",
  action = "add",
  ...
)

\method{gate}{spec_tbl_df}(
  .data,
  .element,
  .dim1,
  .dim2,
  .color = NULL,
  .shape = NULL,
  .size = NULL,
  opacity = 1,
  how_many_gates = 1,
  gate_list = NULL,
  name = "gate",
  action = "add",
  ...
)

\method{gate}{tbl_df}(
  .data,
  .element,
  .dim1,
  .dim2,
  .color = NULL,
  .shape = NULL,
  .size = NULL,
  opacity = 1,
  how_many_gates = 1,
  gate_list = NULL,
  name = "gate",
  action = "add",
  ...
)
}
\arguments{
\item{.data}{A tibble}

\item{.element}{A column symbol. The column that is used to calculate distance (i.e., normally genes)}

\item{.dim1}{A column symbol. The x dimension}

\item{.dim2}{A column symbol. The y dimension}

\item{.color}{A column symbol. Color of points}

\item{.shape}{A column symbol. Shape of points}

\item{.size}{A column symbol. Size of points}

\item{opacity}{A number between 0 and 1. The opacity level of the data points}

\item{how_many_gates}{An integer. The number of gates to label}

\item{gate_list}{A list of gates. It is returned by gate function as attribute \"gate\". If you want to create this list yourself, each element of the list is a data frame with x and y columns. Each row is a coordinate. The order matter.}

\item{name}{A character string. The name of the new column}

\item{action}{A character string. Whether to join the new information to the input tbl (add), or just get the non-redundant tbl with the new information (get).}

\item{...}{Further parameters passed to the function gatepoints::fhs}
}
\value{
A tbl object with additional columns for the inside gate information. additional columns for the rotated dimensions. The rotated dimensions will be added to the original data set as `<NAME OF DIMENSION> rotated <ANGLE>` by default, or as specified in the input arguments.

A tbl object with additional columns for the reduced dimensions. additional columns for the rotated dimensions. The rotated dimensions will be added to the original data set as `<NAME OF DIMENSION> rotated <ANGLE>` by default, or as specified in the input arguments.

A tbl object with additional columns for the reduced dimensions. additional columns for the rotated dimensions. The rotated dimensions will be added to the original data set as `<NAME OF DIMENSION> rotated <ANGLE>` by default, or as specified in the input arguments.
}
\description{
gate() takes as input a `tbl` formatted as | <DIMENSION 1> | <DIMENSION 2> | <...> | and calculates the rotated dimensional space of the feature value.
}
\details{
\lifecycle{maturing}

This function allow the user to label data points in inside one or more 2D gates. This package is based on on the package gatepoints.
}
\examples{

\donttest{

  if(interactive()){

    tidygate::tidygate_data \%>\%
    gate( .element = c(`ct 1`, `ct 2`), Dim1, Dim2 )

  }

}

library(magrittr)

tidygate::tidygate_data  \%>\%
 gate(
   .element = c(`ct 1`, `ct 2`),
   Dim1, Dim2,
   gate_list = tidygate::gate_list
 )

}
\keyword{internal}
