% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longer_dt.R
\name{longer_dt}
\alias{longer_dt}
\title{Pivot data from wide to long}
\usage{
longer_dt(
  data,
  ...,
  gathered_name = "variable",
  gathered_value = "value",
  group_to_keep = NULL,
  negate = FALSE,
  na.rm = FALSE
)
}
\arguments{
\item{data}{A data.frame}

\item{...}{Pattern for unchanged group or unquoted names. Pattern can accept
regular expression to match column names. If set `negate = TRUE`,
return non-matching columns.}

\item{gathered_name}{name for the measured variable names column.
The default name is 'variable'.}

\item{gathered_value}{name for the molten data values column(s).
The default name is 'value'.}

\item{group_to_keep}{Group to keep, namely vector of unchanged variables.
Can be integer (corresponding id column numbers) or
character (id column names) vector.}

\item{negate}{If \code{TRUE}, return non-matching elements.}

\item{na.rm}{If \code{TRUE}, \code{NA} values will be removed from the molten data.}
}
\value{
A data.table
}
\description{
Analogous function for \code{pivot_longer} in \pkg{tidyr}.
}
\examples{

## Example 1:
stocks = data.frame(
  time = as.Date('2009-01-01') + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4)
)

stocks

stocks \%>\%
  longer_dt(time)

stocks \%>\%
  longer_dt("ti")

# Example 2:
\donttest{
library(tidyr)

billboard \%>\%
  longer_dt(
    "wk",
    gathered_name = "week",
    gathered_value = "rank",
    na.rm = TRUE,negate = TRUE
  )

# or use:
 billboard \%>\%
   longer_dt(
     artist,track,date.entered,
     gathered_name = "week",
     gathered_value = "rank",
     na.rm = TRUE,negate = TRUE
   )

 # or use:
 billboard \%>\%
   longer_dt(
     group_to_keep = 1:3,
     gathered_name = "week",
     gathered_value = "rank",
     na.rm = TRUE,negate = TRUE
   )
}
}
\seealso{
\code{\link[data.table]{melt}}

\code{\link[tidyr]{pivot_longer}}
}
