% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data_factors.R
\name{download_data_factors}
\alias{download_data_factors}
\title{Download and Process Factor Data}
\usage{
download_data_factors(type, start_date, end_date)
}
\arguments{
\item{type}{The type of dataset to download, indicating the factor model and
frequency.}

\item{start_date}{The start date for filtering the data, in "YYYY-MM-DD"
format.}

\item{end_date}{The end date for filtering the data, in "YYYY-MM-DD" format.}
}
\value{
A tibble with processed factor data, including dates, risk-free
rates, market excess returns, and other factors, filtered by the specified
date range.
}
\description{
Downloads and processes factor data based on the specified type (Fama-French
or Global Q), and date range. This function delegates to specific functions
based on the type of factors requested: Fama-French or Global Q. It checks if
the specified type is supported before proceeding with the download and
processing.
}
\examples{
\donttest{
  download_data_factors("factors_ff_3_monthly", "2000-01-01", "2020-12-31")
  download_data_factors("factors_ff_3_daily")
  download_data_factors("factors_q5_daily", "2020-01-01", "2020-12-31")
}
}
