% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar_chart_waterfall.R
\name{bar_chart_waterfall}
\alias{bar_chart_waterfall}
\title{Generate horizontal waterfall chart}
\usage{
bar_chart_waterfall(
  cat,
  series,
  data = NULL,
  add_result = FALSE,
  result_title = NULL
)
}
\arguments{
\item{cat}{vector containing category names of values}

\item{series}{vector containing names of columns in data with values to plot}

\item{data}{data frame containing data to be plotted}

\item{add_result}{boolean value if result bar should be plotted}

\item{result_title}{the title for the result bar. Ignored if add_result is false}
}
\value{
SVG string containing chart
}
\description{
Generate horizontal waterfall chart
}
\examples{
df <- data.frame(
  city = c("Berlin", "Munich", "Cologne", "London", "Vienna", "Paris", "Zurich"),
  profit = sin(1:7)
)

bar_chart_waterfall(cat = 'city', series = 'profit', data = df) \%>\% SVGrenderer()
}
