% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column_chart_functions.R
\name{add_bars}
\alias{add_bars}
\title{add bars to svg string}
\usage{
add_bars(
  svg_string,
  df,
  x,
  series,
  bar_width,
  styles = NULL,
  x_offset = 0,
  translate = c(0, 0),
  add_x_axis = TRUE,
  color = NULL,
  add_legend = FALSE,
  legend_position = "left_top",
  max_val = NULL
)
}
\arguments{
\item{svg_string}{the svg string to br appended, need to be finalized after}

\item{df}{data to be plotted - data frame in wide format}

\item{x}{vector to be on x axis}

\item{series}{character vector of column names representing series to split bars by it}

\item{bar_width}{the width of plotted bar}

\item{styles}{vector of styles of the bars}

\item{x_offset}{how much bars should be offset to the right (negative value means offsetting to the left)}

\item{translate}{vector of translation of the bars from the origin}

\item{add_x_axis}{boolean flag, if true automatically adds x axis with label}

\item{color}{optional custom color of the bars series, in svg string format, ie.: "rgb(223,12,121)" or "black"}

\item{add_legend}{boolean flag if legend should be added}

\item{legend_position}{string with legend position}

\item{max_val}{maximal value that bars will be scaled to}
}
\value{
svg string with added bars
}
\description{
add bars to svg string
}
