% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_names.R
\name{analyse_cells}
\alias{analyse_cells}
\title{Analyse Cells}
\usage{
analyse_cells(d, silent = TRUE)
}
\arguments{
\item{d}{A \code{\link[=cell_df-class]{cell_df}} after \code{\link[=value_attribute_classify]{Value Attribute Classification}} done}

\item{silent}{logical scalar indicating whether to raise a warning if heuristic detection fails. (Default TRUE).}
}
\value{
Detailed analysis of the cell data structure.
Which will be a \code{\link[=cell_analysis-class]{cell_analysis}} class object.
}
\description{
Note that this is an other name for \code{tidycells::analyze_cells}.
After \code{\link[=value_attribute_classify]{Value Attribute Classification}} done on a \code{\link[=cell_df-class]{cell_df}} next task to do is
analyze it's contents for data block detection, attribute orientation identification etc. The function \code{analyze_cells} (and also \code{analyse_cells})
does the same for you.

\strong{Note}:
\if{html}{If you are not sure about what package functions actually do or how they work together,
please start with \href{../doc/tidycells-intro.html}{\code{vignette("tidycells-intro")}}.}
\if{latex}{If you are not sure about what package functions actually do or how they work together,
please start with \code{vignette("tidycells-intro")}.}
}
\details{
it returns detailed analysis of the data structure including data block detection, attribute orientation detection etc.
The argument \code{silent} is set to \code{TRUE} by default, as the warning will be given whenever the \code{\link[=cell_analysis-class]{cell_analysis}} is printed.

After this step one may like to do :
\itemize{
\item \code{\link[=compose_cells]{compose_cells}}
}

If in an interactive session, following additional functions can be helpful for interactive visualizations:
\itemize{
\item \code{\link[=visual_data_block_inspection]{visual_data_block_inspection}}
\item \code{\link[=visual_orientation_modification]{visual_orientation_modification}}
\item \code{\link[=visual_traceback]{visual_traceback}}
}
}
\seealso{
\code{\link[=compose_cells]{compose_cells}}, \code{\link[=collate_columns]{collate_columns}}, \code{\link[=analyze_cells]{analyze_cells}}
}
\keyword{internal}
