% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results-table_results.R
\name{conf_int}
\alias{conf_int}
\title{Format confidence intervals}
\usage{
conf_int(x, digits = 2, se = NULL, lb = NULL, ub = NULL, ci = 95)
}
\arguments{
\item{x}{Optional. An object for which a method exists.}

\item{digits}{Integer. The number of digits to round the confidence
boundaries to.}

\item{se}{Optional, numeric. Standard error of the parameters.}

\item{lb}{Optional, numeric. Lower boundary of confidence intervals.}

\item{ub}{Optional, numeric. Upper boundary of confidence intervals.}

\item{ci}{Optional, numeric. What percentage CI to use (only used when
computing CI from a numeric vector \code{x}, and the standard error
\code{se}, based on a normal distribution).}
}
\value{
A character vector of formatted confidence intervals.
}
\description{
Creates 'APA'-formatted confidence intervals, either from an object for which
a method exists, or from the arguments \code{lb} and \code{ub}. When argument
\code{x} is a numeric vector, it is also possible to construct a confidence
interval using the standard error (\code{se}) and a percentile interval
(\code{ci}).
}
\examples{
conf_int(x = c(1.325, 2.432), se = c(.05336, .00325))
}
\seealso{
table_results est_sig

Other Reporting tools: 
\code{\link{est_sig}()},
\code{\link{table_fit}()},
\code{\link{table_prob}()},
\code{\link{table_results}()}
}
\author{
Caspar J. van Lissa
}
\concept{Reporting tools}
