% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{paste2}
\alias{paste2}
\title{Concatenate Strings while omitting NA}
\usage{
paste2(..., sep = " ", collapse = NULL, na.rm = TRUE)
}
\arguments{
\item{...}{one or more R objects, to be converted to character vectors.}

\item{sep}{a character string to separate the terms.
Not \code{NA_character_}.}

\item{collapse}{an optional character string to separate the results.
Not \code{NA_character_}.}

\item{na.rm}{logical, indicating whether \code{NA} values should be stripped
before concatenation.
Not \code{NA_character_}.}
}
\value{
A character vector of the concatenated values.
}
\description{
Concatenate vectors after converting to character and removing
\code{NA} values. See \code{\link{paste}}.
}
\examples{
paste2("word", NA)
}
