% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_alpha_reg.R
\name{micro_alpha_reg}
\alias{micro_alpha_reg}
\title{Linear regression on alpha diversities within a micro_set}
\usage{
micro_alpha_reg(alpha_set, table, ...)
}
\arguments{
\item{alpha_set}{A tidy_micro data set with alpha diversities calculated by \code{alpha_div}}

\item{table}{OTU table of interest}

\item{...}{Covariates of interest. Can include interaction terms such as \code{Group*Age}}
}
\value{
A data frame containing the model estimates for each alpha diversity
}
\description{
A simple wrapper to run standard linear regression though the \code{\link[stats]{lm}} function. Will only use alpha diversities distinct libraries (Lib) from the specified table as to not inflate the sample size
}
\note{
Be aware of your minimal sequencing depth as this will be the size of all bootstrapped resamples (rarefied).
}
\examples{
data(bpd_phy); data(bpd_cla); data(bpd_ord); data(bpd_fam); data(bpd_clin)

otu_tabs <- list(Phylum = bpd_phy, Class = bpd_cla,
Order = bpd_ord, Family = bpd_fam)
set <- tidy_micro(otu_tabs = otu_tabs, clinical = bpd_clin) \%>\%
filter(day == 7) ## Only including first week

\donttest{
set_fam_alpha <- set \%>\% alpha_div(table = "Family", min_depth = 5000, min_goods = 90)
set_fam_alpha \%>\% micro_alpha_reg(table = "Family", bpd1)
}
}
